DROP PROCEDURE [hips].[AddressUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 15 October 2012
-- Description:   Updates an existing record into the Addresss Table
-- =============================================
CREATE PROCEDURE [hips].[AddressUpdate] 
(      @AddressId INT
      ,@AddressLine1 VARCHAR(100)
      ,@AddressLine2 VARCHAR(100) = null
      ,@PlaceName VARCHAR(100) = null
      ,@AustralianStateId INT
      ,@InternationalStateCode VARCHAR(10) = NULL
      ,@Postcode VARCHAR(10) = null
      ,@CountryId INT
      ,@AddressTypeId INT
	  ,@UserModified VARCHAR(256)
	  ,@DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[Address]
				WHERE [AddressId] = @AddressId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[Address]
           SET [AddressLine1] = @AddressLine1
			  ,[AddressLine2] = @AddressLine2
			  ,[PlaceName] = @PlaceName
			  ,[AustralianStateId] = @AustralianStateId
			  ,[InternationalStateCode] = @InternationalStateCode
			  ,[Postcode] = @Postcode
			  ,[CountryId] = @CountryId
			  ,[AddressTypeId] = @AddressTypeId
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
         WHERE [AddressID] = @AddressID

        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT  a.AddressId,
				a.AddressLine1,
				a.AddressLine2,
				a.PlaceName,
				a.AustralianStateId,
				st.Description AS AustralianStateName,
				a.InternationalStateCode,
				a.PostCode,
				a.CountryId,
				c.DESCRIPTION AS CountryName,
				a.AddressTypeId,
				at.DESCRIPTION AS AddressTypeDescription,
				a.DateCreated,
				a.UserCreated,
				a.DateModified,
				a.UserModified	
		FROM  hips.Address a
		LEFT OUTER JOIN hips.State AS st ON st.StateID = a.AustralianStateId
		Inner JOIN hips.Country AS c ON c.CountryId = a.CountryId
		INNER JOIN hips.AddressType AS at ON at.AddressTypeId = a.AddressTypeId
		WHERE a.AddressId = @AddressId
    END

    RETURN(@intErrorCode)

END
GO

